(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6235,        191]*)
(*NotebookOutlinePosition[      6877,        213]*)
(*  CellTagsIndexPosition[      6833,        209]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(x[v_, \[Theta]_, t_] := 
        v\ Cos[\[Theta]]\ t;\)\), "\[IndentingNewLine]", 
    \(y[v_, \[Theta]_, t_] := v\ Sin[\[Theta]]\ t\  - 5  t\^2\)}], "Input"],

Cell[BoxData[
    \(Solve[y[v, \[Theta], t] \[Equal] 0, t]\)], "Input"],

Cell[BoxData[
    \(tiempo[v_, \[Theta]_] := 1\/5\ v\ Sin[\[Theta]]\)], "Input"],

Cell[BoxData[
    \(x[v, \[Theta], tiempo[v, \[Theta]]]\)], "Input"],

Cell[BoxData[
    \(alcance[v_, \[Theta]_] := 
      1\/5\ v\^2\ Cos[\[Theta]]\ Sin[\[Theta]]\)], "Input"],

Cell[BoxData[
    \(Solve[D[y[v, \[Theta], t], t] \[Equal] 0, t]\)], "Input"],

Cell[BoxData[
    \(y[v, \[Theta], t /. %[\([1]\)]]\)], "Input"],

Cell[BoxData[
    \(altura[v_, \[Theta]_] := 1\/20\ v\^2\ Sin[\[Theta]]\^2\)], "Input"],

Cell[BoxData[
    \(parabola1 = 
      ParametricPlot[{x[100, \[Pi]\/3, t], y[100, \[Pi]\/3, t]}, {t, 0, 5}, \ 
        DisplayFunction \[Rule] Identity]\)], "Input"],

Cell[BoxData[
    \(\(bala = 
        Graphics[{Hue[0], PointSize[ .03], 
            Point[{x[100, \[Pi]\/3, 5], y[100, \[Pi]\/3, 5]}]}];\)\)], "Input"],

Cell[BoxData[
    \(Show[{parabola1, bala}, DisplayFunction \[Rule] $DisplayFunction, 
      AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[BoxData[
    \(Clear[bala, parabola1]\)], "Input"],

Cell[BoxData[
    \(parabola[v_, \[Theta]_, T_] := 
      ParametricPlot[{x[v, \[Theta], t], y[v, \[Theta], t]}, {t, 0, T}, 
        PlotRange \[Rule] {{\(-10\), alcance[v, \[Theta]] + 10}, {\(-10\), 
              altura[v, \[Theta]] + 15}}, 
        DisplayFunction \[Rule] Identity]\)], "Input"],

Cell[BoxData[
    \(bala[v_, \[Theta]_, T_] := 
      Graphics[{Hue[0], PointSize[ .03], 
          Point[{x[v, \[Theta], T], y[v, \[Theta], T]}]}]\)], "Input"],

Cell[BoxData[
    \(\(tiro[v_, \[Theta]_] := 
        Do[Show[{parabola[v, \[Theta], T], bala[v, \[Theta], T]}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            AspectRatio \[Rule] Automatic], {T,  .01, 
            tiempo[v, \[Theta]] +  .01, 
            tiempo[v, \[Theta]]/10}];\)\)], "Input"],

Cell[BoxData[
    \(tiro[100, \[Pi]\/3]\)], "Input"],

Cell[BoxData[
    \(tiro[100, Pi/4]\)], "Input"],

Cell[BoxData[
    \(Clear[graficas, disparo]\)], "Input"],

Cell[BoxData[
    \(graficas[v_, \[Theta]_, T_] := 
      Show[{parabola[v, \[Theta], T], bala[v, \[Theta], T]}, 
        DisplayFunction \[Rule] $DisplayFunction, 
        AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[BoxData[
    \(\(disparo[v_, \[Theta]_] := 
        Table[graficas[v, \[Theta], T], {T,  .01, tiempo[v, \[Theta]] +  .03, 
            tiempo[v, \[Theta]]/10}];\)\)], "Input"],

Cell[BoxData[
    \(Clear[dispara, disparo]\)], "Input"],

Cell[BoxData[
    \(disparo[100, \[Pi]\/3]\)], "Input"],

Cell[BoxData[
    \(disparo[100, \[Pi]\/4]\)], "Input"],

Cell[BoxData[
    \(Do[Plot[x^n, {x, 0, 1}, PlotRange \[Rule] {0, 1}], {n, 5}]\)], "Input"],

Cell[BoxData[
    \(Do[ParametricPlot[{Cos[3  x], Sin[5  x]}, {x, 0, t}, 
        PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}, 
        AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {RGBColor[N[t/\((2  Pi + 1/5)\)], 
              N[Abs[1 - t/\((2  Pi)\)]], 0]}], {t, 1/5, 2  Pi + 1/5, 
        1/5}]\)], "Input"],

Cell[BoxData[
    \(Do[ParametricPlot[{Cos[3  x], Sin[5  x]}, {x, t, t + 1/5}, 
        PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}, 
        AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {RGBColor[N[t/\((2  Pi + 1/5)\)], 
              N[Abs[1 - t/\((2  Pi)\)]], 0]}], {t, 0, 2  Pi, 1/5}]\)], "Input"],

Cell[BoxData[
    \(\(Table[
        ParametricPlot[{Cos[3  x], Sin[5  x]}, {x, t, t + 1/7}, 
          PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}, 
          AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] Hue[t]], {t, 0, 2  Pi, 1/7}];\)\)], "Input"],

Cell[BoxData[
    \(Show[%, DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(lazo[t_] := 
      ParametricPlot[{Cos[3  x], Sin[5  x]}, {x, 0, t}, 
        PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity, 
        PlotStyle \[Rule] Hue[t]]\)], "Input"],

Cell[BoxData[
    \(lapiz[t_] := 
      Graphics[{Hue[0], PointSize[ .03], 
          Point[{Cos[3  t], Sin[5  t]}]}]\)], "Input"],

Cell[BoxData[
    \(Do[Show[lazo[t], lapiz[t], 
        DisplayFunction \[Rule] $DisplayFunction], {t, 1/5, 2  Pi + 1/5, 
        1/5}]\)], "Input"],

Cell[BoxData[
    \(Show[%]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 181, 3, 50, "Input"],
Cell[1889, 55, 71, 1, 30, "Input"],
Cell[1963, 58, 80, 1, 42, "Input"],
Cell[2046, 61, 68, 1, 30, "Input"],
Cell[2117, 64, 106, 2, 42, "Input"],
Cell[2226, 68, 77, 1, 30, "Input"],
Cell[2306, 71, 64, 1, 30, "Input"],
Cell[2373, 74, 87, 1, 42, "Input"],
Cell[2463, 77, 166, 3, 40, "Input"],
Cell[2632, 82, 153, 3, 40, "Input"],
Cell[2788, 87, 136, 2, 30, "Input"],
Cell[2927, 91, 55, 1, 30, "Input"],
Cell[2985, 94, 298, 5, 50, "Input"],
Cell[3286, 101, 160, 3, 30, "Input"],
Cell[3449, 106, 316, 6, 70, "Input"],
Cell[3768, 114, 52, 1, 40, "Input"],
Cell[3823, 117, 48, 1, 30, "Input"],
Cell[3874, 120, 57, 1, 30, "Input"],
Cell[3934, 123, 216, 4, 50, "Input"],
Cell[4153, 129, 180, 3, 30, "Input"],
Cell[4336, 134, 56, 1, 30, "Input"],
Cell[4395, 137, 55, 1, 40, "Input"],
Cell[4453, 140, 55, 1, 40, "Input"],
Cell[4511, 143, 91, 1, 30, "Input"],
Cell[4605, 146, 326, 6, 70, "Input"],
Cell[4934, 154, 315, 5, 70, "Input"],
Cell[5252, 161, 299, 5, 50, "Input"],
Cell[5554, 168, 82, 1, 30, "Input"],
Cell[5639, 171, 265, 5, 50, "Input"],
Cell[5907, 178, 130, 3, 30, "Input"],
Cell[6040, 183, 148, 3, 30, "Input"],
Cell[6191, 188, 40, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

